﻿
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IS_sp_UpdateOrCreateRespondentHistory]') AND type in (N'P', N'	PC'))
DROP PROCEDURE [dbo].[IS_sp_UpdateOrCreateRespondentHistory]
GO
CREATE  PROCEDURE [dbo].[IS_sp_UpdateOrCreateRespondentHistory]
	@A4SCallNumber		 INT,
	@ProjectId           INT,
	@CollectMode         INT,
	@HisRespondent       VARCHAR(10),
	@HisResult           VARCHAR(2),
	@HisCallDate         DATETIME,
	@HisCallDuration     INT,
	@HisStartQuestion    VARCHAR(10),
	@HisEndQuestion      VARCHAR(10)
AS
BEGIN
	UPDATE [Historic] SET
		[HisResult] = @HisResult,
		[HisCallDuration] = @HisCallDuration,
		[HisStartQuestion] = @HisStartQuestion,
		[HisEndQuestion] = @HisEndQuestion
	WHERE [HisRespondent] = @HisRespondent AND [A4SCallNumber] = @A4SCallNumber
	
	IF @@ROWCOUNT = 0
	BEGIN
		DECLARE @callNumber INT
		SELECT @callNumber = (CAST(ISNULL(MAX([HisCallNumber]),0) AS BIGINT) + 1) FROM [Historic] WHERE [HisRespondent] = @HisRespondent
	
		INSERT INTO [Historic] ([A4SCallNumber], [HisRespondent], [HisCallNumber], [HisInterviewer], [HisResult], [HisCallDate], [HisCallDuration], [HisStartQuestion], [HisEndQuestion], [HisWait], [HisPause], [collectMode], [projectId], [DialingMode], [LevelChanged], [IsImported])
		VALUES (@A4SCallNumber, @HisRespondent, @callNumber, '***', @HisResult, @HisCallDate, @HisCallDuration, @HisStartQuestion, @HisEndQuestion, 0, 0, @CollectMode, @ProjectId, 0, 0, 0)	
	END
	
	SELECT [HisCallNumber] FROM [Historic] WHERE [HisRespondent] = @HisRespondent AND [A4SCallNumber] = @A4SCallNumber
END
GO



